# created by kodifitzwell for Fenomscrapers
"""
	Fenomscrapers Project
"""

#from json import loads as jsloads
import re, requests, queue
#from fenom import client
from resources.lib.modules import scrape_utils, source_utils


class source:
	priority = 1
	pack_capable = True
	hasMovies = True
	hasEpisodes = True
	_queue = queue.SimpleQueue()
	def __init__(self):
		self.language = ['en']
		self.base_link = "https://zilean.elfhosted.com"
		self.movieSearch_link = '/dmm/filtered?ImdbId=%s'
		self.tvSearch_link = '/dmm/filtered?ImdbId=%s&Season=%s&Episode=%s'
		self.min_seeders = 0

	def sources(self, data, hostDict):
		sources = []
		if not data: return sources
		append = sources.append
		try:
			title = data['tvshowtitle'] if 'tvshowtitle' in data else data['title']
			title = title.replace('&', 'and').replace('Special Victims Unit', 'SVU').replace('/', ' ')
			aliases = data['aliases']
			episode_title = data['title'] if 'tvshowtitle' in data else None
			year = data['year']
			imdb = data['imdb']
			if 'tvshowtitle' in data:
				season = data['season']
				episode = data['episode']
				hdlr = 'S%02dE%02d' % (int(season), int(episode))
				url = '%s%s' % (self.base_link, self.tvSearch_link % (imdb, season, episode))
			else:
				url = '%s%s' % (self.base_link, self.movieSearch_link % imdb)
				hdlr = year
			# log_utils.log('url = %s' % url)
			try:
				results = requests.get(url, timeout=5) # client.request(url, timeout=5)
				files = results.json() # jsloads(results)
			except: files = []
			self._queue.put_nowait(files) # if seasons
			self._queue.put_nowait(files) # if shows
		except:
			source_utils.scraper_error('ZILEAN')
			return sources

		for file in files:
			try:
				hash = file['info_hash']
				name = scrape_utils.clean_name(file['raw_title'])

				if not scrape_utils.check_title(title, aliases, name.replace('.(Archie.Bunker', ''), hdlr, year): continue
				name_info = scrape_utils.info_from_name(name, title, year, hdlr, episode_title)

				url = 'magnet:?xt=urn:btih:%s&dn=%s' % (hash, name) 
				quality, info = scrape_utils.get_release_quality(name_info, url)
				try:
					dsize, isize = scrape_utils.convert_size(float(file["size"]), to='GB')
					info.insert(0, isize)
				except: dsize = 0
				info = ' | '.join(info)

				append({'provider': 'zilean', 'source': 'torrent', 'seeders': 0, 'hash': hash, 'name': name, 'name_info': name_info, 'quality': quality,
							'language': 'en', 'url': url, 'info': info, 'direct': False, 'debridonly': True, 'size': dsize})
			except:
				source_utils.scraper_error('ZILEAN')
		return sources

	def sources_packs(self, data, hostDict, search_series=False, total_seasons=None, bypass_filter=False):
		sources = []
		if not data: return sources
		sources_append = sources.append
		try:
			title = data['tvshowtitle'].replace('&', 'and').replace('Special Victims Unit', 'SVU').replace('/', ' ')
			aliases = data['aliases']
			imdb = data['imdb']
			year = data['year']
			season = data['season']
			url = '%s%s' % (self.base_link, self.tvSearch_link % (imdb, season, data['episode']))
#			results = requests.get(url, timeout=5) # client.request(url, timeout=5)
			files = self._queue.get(timeout=6) # jsloads(results)
		except:
			source_utils.scraper_error('ZILEAN')
			return sources

		for file in files:
			try:
				hash = file['info_hash']
				name = scrape_utils.clean_name(file['raw_title'])

				episode_start, episode_end = 0, 0
				if not search_series:
					if not bypass_filter:
						valid, episode_start, episode_end = scrape_utils.filter_season_pack(title, aliases, year, season, name.replace('.(Archie.Bunker', ''))
						if not valid: continue
					package = 'season'

				elif search_series:
					if not bypass_filter:
						valid, last_season = scrape_utils.filter_show_pack(title, aliases, imdb, year, season, name.replace('.(Archie.Bunker', ''), total_seasons)
						if not valid: continue
					else: last_season = total_seasons
					package = 'show'

				name_info = scrape_utils.info_from_name(name, title, year, season=season, pack=package)

				url = 'magnet:?xt=urn:btih:%s&dn=%s' % (hash, name)
				quality, info = scrape_utils.get_release_quality(name_info, url)
				try:
					dsize, isize = scrape_utils.convert_size(float(file["size"]), to='GB')
					info.insert(0, isize)
				except: dsize = 0
				info = ' | '.join(info)

				item = {'provider': 'zilean', 'source': 'torrent', 'seeders': 0, 'hash': hash, 'name': name, 'name_info': name_info, 'quality': quality,
							'language': 'en', 'url': url, 'info': info, 'direct': False, 'debridonly': True, 'size': dsize, 'package': package}
				if search_series: item.update({'last_season': last_season})
				elif episode_start: item.update({'episode_start': episode_start, 'episode_end': episode_end}) # for partial season packs
				sources_append(item)
			except:
				source_utils.scraper_error('ZILEAN')
		return sources
