<img src="https://raw.githubusercontent.com/mikesilvo164/script.skinshortcuts/master/resources/media/icon.png" width="256" height="256" alt="Skin Shortcuts">

# Skin Shortcuts

[![Build Status](https://img.shields.io/endpoint.svg?url=https%3A%2F%2Factions-badge.atrox.dev%2Fmikesilvo164%2Fscript.skinshortcuts%2Fbadge&logo=none)](https://actions-badge.atrox.dev/mikesilvo164/script.skinshortcuts/goto)
![License](https://img.shields.io/badge/license-GPL--2.0--only-success.svg)
![Kodi Version](https://img.shields.io/badge/kodi-matrix%2B-success.svg)
![Contributors](https://img.shields.io/github/contributors/mikesilvo164/script.skinshortcuts.svg)
![GitHub Latest Release](https://img.shields.io/github/v/release/mikesilvo164/script.skinshortcuts)

script.skinshortcuts was written with the intention of making user customizable shortcuts on the home page easier for skinners.

## What's New for Skinners

See the [latest release](https://github.com/mikesilvo164/script.skinshortcuts/releases/latest) for a complete list of changes

## With Thanks

Because their names don't deserve to be at the bottom 😃

- Huge thanks to Ronie, whose code for listing plugins is used in this script
- Equally, huge thanks to Ronie and 'Black, for their favourites code used in this script
- More huge thanks to BigNoid, for the ability to edit shortcuts, and Jeroen, for so many suggestions each of which just made the script better.
- The thanks remain absolutely huge to the translators on Transifex/Weblate for localising the script
- There almost isn't enough thanks for schimi2k for the icon and fanart
- Everyone who has contributed even one idea or line of code
- And the biggest thanks of all to Annie and my family, for feature suggestions, testing and shouting at me when I broke things

## Where To Get Help - Users

[End User FAQ](./docs/FAQ.md)

If you have issues with using the script, your first port of call should be the End User FAQ. If your query isn't listed there, then the next place to ask for help is the [Kodi forum for the skin that you are using](https://forum.kodi.tv/forumdisplay.php?fid=67). There are a lot of very knowledgeable skinners and users who will be able to answer most questions.

When a question comes up that no-one in the thread can answer, the skinner may direct you to the [Skin Shortcuts thread](https://forum.kodi.tv/showthread.php?tid=178294) in the skin development for further help.

If you experience an error with the script, you are welcome to ask for help directly in the Skin Shortcuts thread in the skin development forum. However, we _require_ a [debug log](https://kodi.wiki/view/Debug_log).

Please note that this thread is primarily aimed at skin developers - if you haven't already asked in the relevant skin's forum, included a debug log or are asking a question related to [banned add-ons](https://kodi.wiki/view/Official:Forum_rules/Banned_add-ons), you are not likely to receive a warm welcome.

## Where To Get Help - Skinners

Though hopefully Skin Shortcuts will save you a lot of code in the long-run, it is a relatively complex script and so may take some time to get your head around.

To help, it includes a lot of documentation covering the various features of the script

* [What is Skin Shortcuts](./docs/What%20is%20Skin%20Shortcuts.md)
* [Getting Started](./docs/started/Getting%20Started.md)
* [Providing default shortcuts](./docs/Providing%20default%20shortcuts.md)
* [Advanced usage topics](./docs/advanced/Advanced%20Usage.md)
* [labelID and localisation](./docs/labelID%20and%20Localisation.md)

It's highly recommended taking the time to read through these documents before you begin.

If you require any assistance post on the Kodi forum, and I'll do my best to assist:

[http://forum.kodi.tv/showthread.php?tid=178294](https://forum.kodi.tv/showthread.php?tid=178294)

## Documentation for different versions

The documentation with Skin Shortcuts is generally updated as features are added or changed. Therefore, the docs on Git refer to the latest build, and will include details of features that are not yet on the repo.

If you are targeting the repo version of the script you can use the tags to browse the documentation for that particular release.
